require = GLOBAL.require

local Travel_Cost = GetModConfigData("Travel_Cost")
local TravelableTag = 'travelable'

local function TravelableInit(inst)
	inst:AddComponent("signable")
	inst:AddComponent("travelable")
	inst:AddComponent("talker")
end

AddPrefabPostInit("homesign", TravelableInit)

-- Actions ------------------------------
local Action = GLOBAL.Action
local ActionHandler = GLOBAL.ActionHandler

local SIGNEDIT = Action(2,true)
SIGNEDIT.str = "Edit"
SIGNEDIT.id = "SIGNEDIT"
SIGNEDIT.fn = function(act)
	local tar = act.target
	if tar and tar.components.signable then
        	tar.components.signable:OnSign(tar)
        	return true
	end
end

AddAction(SIGNEDIT)

local DESTINATION = Action(2, nil, true)
DESTINATION.str = "Select Destination"
DESTINATION.id = "DESTINATION"
DESTINATION.fn = function(act)
	local tar = act.target
	if act.doer ~= nil and tar ~= nil and act.doer:HasTag("player") and tar.components.travelable and not tar:HasTag("burnt") and not tar:HasTag("fire") then
		tar.components.travelable:SelectDestination(act.doer)
		return true
	end
end

AddAction(DESTINATION)
AddStategraphActionHandler("wilson", ActionHandler(DESTINATION, "give"))